package microsoft.graph.search.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "keywords", 
    "matchSimilarKeywords", 
    "reservedKeywords"})
@JsonInclude(Include.NON_NULL)
public class AnswerKeyword implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("keywords")
    protected List<String> keywords;

    @JsonProperty("keywords@nextLink")
    protected String keywordsNextLink;

    @JsonProperty("matchSimilarKeywords")
    protected Boolean matchSimilarKeywords;

    @JsonProperty("reservedKeywords")
    protected List<String> reservedKeywords;

    @JsonProperty("reservedKeywords@nextLink")
    protected String reservedKeywordsNextLink;

    protected AnswerKeyword() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.search.answerKeyword";
    }

    @Property(name="keywords")
    @JsonIgnore
    public CollectionPage<String> getKeywords() {
        return new CollectionPage<String>(contextPath, String.class, this.keywords, Optional.ofNullable(keywordsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="keywords")
    @JsonIgnore
    public CollectionPage<String> getKeywords(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.keywords, Optional.ofNullable(keywordsNextLink), Collections.emptyList(), options);
    }

    @Property(name="matchSimilarKeywords")
    @JsonIgnore
    public Optional<Boolean> getMatchSimilarKeywords() {
        return Optional.ofNullable(matchSimilarKeywords);
    }

    public AnswerKeyword withMatchSimilarKeywords(Boolean matchSimilarKeywords) {
        AnswerKeyword _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.search.answerKeyword");
        _x.matchSimilarKeywords = matchSimilarKeywords;
        return _x;
    }

    @Property(name="reservedKeywords")
    @JsonIgnore
    public CollectionPage<String> getReservedKeywords() {
        return new CollectionPage<String>(contextPath, String.class, this.reservedKeywords, Optional.ofNullable(reservedKeywordsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="reservedKeywords")
    @JsonIgnore
    public CollectionPage<String> getReservedKeywords(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.reservedKeywords, Optional.ofNullable(reservedKeywordsNextLink), Collections.emptyList(), options);
    }

    public AnswerKeyword withUnmappedField(String name, Object value) {
        AnswerKeyword _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> keywords;
        private String keywordsNextLink;
        private Boolean matchSimilarKeywords;
        private List<String> reservedKeywords;
        private String reservedKeywordsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder keywords(String... keywords) {
            return keywords(Arrays.asList(keywords));
        }

        public Builder keywordsNextLink(String keywordsNextLink) {
            this.keywordsNextLink = keywordsNextLink;
            this.changedFields = changedFields.add("keywords");
            return this;
        }

        public Builder matchSimilarKeywords(Boolean matchSimilarKeywords) {
            this.matchSimilarKeywords = matchSimilarKeywords;
            this.changedFields = changedFields.add("matchSimilarKeywords");
            return this;
        }

        public Builder reservedKeywords(List<String> reservedKeywords) {
            this.reservedKeywords = reservedKeywords;
            this.changedFields = changedFields.add("reservedKeywords");
            return this;
        }

        public Builder reservedKeywords(String... reservedKeywords) {
            return reservedKeywords(Arrays.asList(reservedKeywords));
        }

        public Builder reservedKeywordsNextLink(String reservedKeywordsNextLink) {
            this.reservedKeywordsNextLink = reservedKeywordsNextLink;
            this.changedFields = changedFields.add("reservedKeywords");
            return this;
        }

        public AnswerKeyword build() {
            AnswerKeyword _x = new AnswerKeyword();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.search.answerKeyword";
            _x.keywords = keywords;
            _x.keywordsNextLink = keywordsNextLink;
            _x.matchSimilarKeywords = matchSimilarKeywords;
            _x.reservedKeywords = reservedKeywords;
            _x.reservedKeywordsNextLink = reservedKeywordsNextLink;
            return _x;
        }
    }

    private AnswerKeyword _copy() {
        AnswerKeyword _x = new AnswerKeyword();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.keywords = keywords;
        _x.matchSimilarKeywords = matchSimilarKeywords;
        _x.reservedKeywords = reservedKeywords;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AnswerKeyword[");
        b.append("keywords=");
        b.append(this.keywords);
        b.append(", ");
        b.append("matchSimilarKeywords=");
        b.append(this.matchSimilarKeywords);
        b.append(", ");
        b.append("reservedKeywords=");
        b.append(this.reservedKeywords);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
