package microsoft.graph.search.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.graph.search.entity.Bookmark;
import microsoft.graph.search.entity.request.BookmarkEntityRequest;

public class BookmarkCollectionRequest extends CollectionPageEntityRequest<Bookmark, BookmarkEntityRequest>{

    protected ContextPath contextPath;

    public BookmarkCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Bookmark.class, cp -> new BookmarkEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
