package microsoft.graph.search.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.graph.search.entity.Acronym;
import microsoft.graph.search.entity.request.AcronymEntityRequest;

public class AcronymCollectionRequest extends CollectionPageEntityRequest<Acronym, AcronymEntityRequest>{

    protected ContextPath contextPath;

    public AcronymCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Acronym.class, cp -> new AcronymEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
