package microsoft.graph.externalconnectors.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum RuleOperation implements Enum {

    @JsonProperty("null")
    NULL("null", "0"),

    @JsonProperty("equals")
    EQUALS("equals", "1"),

    @JsonProperty("notEquals")
    NOT_EQUALS("notEquals", "2"),

    @JsonProperty("contains")
    CONTAINS("contains", "3"),

    @JsonProperty("notContains")
    NOT_CONTAINS("notContains", "4"),

    @JsonProperty("lessThan")
    LESS_THAN("lessThan", "5"),

    @JsonProperty("greaterThan")
    GREATER_THAN("greaterThan", "6"),

    @JsonProperty("startsWith")
    STARTS_WITH("startsWith", "7"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private RuleOperation(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
