package microsoft.graph.externalconnectors.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum IdentitySourceType implements Enum {

    @JsonProperty("azureActiveDirectory")
    AZURE_ACTIVE_DIRECTORY("azureActiveDirectory", "1"),

    @JsonProperty("external")
    EXTERNAL("external", "2"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "3");

    private final String name;
    private final String value;

    private IdentitySourceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
