package microsoft.graph.externalconnectors.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ConnectionState implements Enum {

    @JsonProperty("draft")
    DRAFT("draft", "1"),

    @JsonProperty("ready")
    READY("ready", "2"),

    @JsonProperty("obsolete")
    OBSOLETE("obsolete", "3"),

    @JsonProperty("limitExceeded")
    LIMIT_EXCEEDED("limitExceeded", "4"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private ConnectionState(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
