package microsoft.graph.externalconnectors.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum AclType implements Enum {

    @JsonProperty("user")
    USER("user", "1"),

    @JsonProperty("group")
    GROUP("group", "2"),

    @JsonProperty("everyone")
    EVERYONE("everyone", "3"),

    @JsonProperty("everyoneExceptGuests")
    EVERYONE_EXCEPT_GUESTS("everyoneExceptGuests", "4"),

    @JsonProperty("externalGroup")
    EXTERNAL_GROUP("externalGroup", "5"),

    @JsonProperty("unknownFutureValue")
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "6");

    private final String name;
    private final String value;

    private AclType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
