package microsoft.graph.externalconnectors.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.graph.externalconnectors.collection.request.IdentityCollectionRequest;
import microsoft.graph.externalconnectors.entity.ExternalGroup;

@JsonIgnoreType
public class ExternalGroupEntityRequest extends EntityRequest<ExternalGroup> {

    public ExternalGroupEntityRequest(ContextPath contextPath, Optional<Object> value) {
        super(ExternalGroup.class, contextPath, value, false);
    }

    public IdentityEntityRequest members(String id) {
        return new IdentityEntityRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityCollectionRequest members() {
        return new IdentityCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

}
