package microsoft.graph.externalconnectors.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import microsoft.graph.externalconnectors.enums.RuleOperation;

import odata.msgraph.client.beta.enums.BinaryOperator;

@JsonPropertyOrder({
    "@odata.type", 
    "operation", 
    "property", 
    "values", 
    "valuesJoinedBy"})
@JsonInclude(Include.NON_NULL)
public class PropertyRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("operation")
    protected RuleOperation operation;

    @JsonProperty("property")
    protected String property;

    @JsonProperty("values")
    protected List<String> values;

    @JsonProperty("values@nextLink")
    protected String valuesNextLink;

    @JsonProperty("valuesJoinedBy")
    protected BinaryOperator valuesJoinedBy;

    protected PropertyRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalConnectors.propertyRule";
    }

    @Property(name="operation")
    @JsonIgnore
    public Optional<RuleOperation> getOperation() {
        return Optional.ofNullable(operation);
    }

    public PropertyRule withOperation(RuleOperation operation) {
        PropertyRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.propertyRule");
        _x.operation = operation;
        return _x;
    }

    @Property(name="property")
    @JsonIgnore
    public Optional<String> getProperty() {
        return Optional.ofNullable(property);
    }

    public PropertyRule withProperty(String property) {
        PropertyRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.propertyRule");
        _x.property = property;
        return _x;
    }

    @Property(name="values")
    @JsonIgnore
    public CollectionPage<String> getValues() {
        return new CollectionPage<String>(contextPath, String.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="values")
    @JsonIgnore
    public CollectionPage<String> getValues(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), options);
    }

    @Property(name="valuesJoinedBy")
    @JsonIgnore
    public Optional<BinaryOperator> getValuesJoinedBy() {
        return Optional.ofNullable(valuesJoinedBy);
    }

    public PropertyRule withValuesJoinedBy(BinaryOperator valuesJoinedBy) {
        PropertyRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.propertyRule");
        _x.valuesJoinedBy = valuesJoinedBy;
        return _x;
    }

    public PropertyRule withUnmappedField(String name, Object value) {
        PropertyRule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RuleOperation operation;
        private String property;
        private List<String> values;
        private String valuesNextLink;
        private BinaryOperator valuesJoinedBy;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder operation(RuleOperation operation) {
            this.operation = operation;
            this.changedFields = changedFields.add("operation");
            return this;
        }

        public Builder property(String property) {
            this.property = property;
            this.changedFields = changedFields.add("property");
            return this;
        }

        public Builder values(List<String> values) {
            this.values = values;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public Builder values(String... values) {
            return values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("values");
            return this;
        }

        public Builder valuesJoinedBy(BinaryOperator valuesJoinedBy) {
            this.valuesJoinedBy = valuesJoinedBy;
            this.changedFields = changedFields.add("valuesJoinedBy");
            return this;
        }

        public PropertyRule build() {
            PropertyRule _x = new PropertyRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.externalConnectors.propertyRule";
            _x.operation = operation;
            _x.property = property;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            _x.valuesJoinedBy = valuesJoinedBy;
            return _x;
        }
    }

    private PropertyRule _copy() {
        PropertyRule _x = new PropertyRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.operation = operation;
        _x.property = property;
        _x.values = values;
        _x.valuesJoinedBy = valuesJoinedBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PropertyRule[");
        b.append("operation=");
        b.append(this.operation);
        b.append(", ");
        b.append("property=");
        b.append(this.property);
        b.append(", ");
        b.append("values=");
        b.append(this.values);
        b.append(", ");
        b.append("valuesJoinedBy=");
        b.append(this.valuesJoinedBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
