package microsoft.graph.externalconnectors.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Json;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "layout", 
    "priority", 
    "rules"})
@JsonInclude(Include.NON_NULL)
public class DisplayTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("layout")
    protected Json layout;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("rules")
    protected List<PropertyRule> rules;

    @JsonProperty("rules@nextLink")
    protected String rulesNextLink;

    protected DisplayTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalConnectors.displayTemplate";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public DisplayTemplate withId(String id) {
        DisplayTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.displayTemplate");
        _x.id = id;
        return _x;
    }

    @Property(name="layout")
    @JsonIgnore
    public Optional<Json> getLayout() {
        return Optional.ofNullable(layout);
    }

    public DisplayTemplate withLayout(Json layout) {
        DisplayTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.displayTemplate");
        _x.layout = layout;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public DisplayTemplate withPriority(Integer priority) {
        DisplayTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.displayTemplate");
        _x.priority = priority;
        return _x;
    }

    @Property(name="rules")
    @JsonIgnore
    public CollectionPage<PropertyRule> getRules() {
        return new CollectionPage<PropertyRule>(contextPath, PropertyRule.class, this.rules, Optional.ofNullable(rulesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="rules")
    @JsonIgnore
    public CollectionPage<PropertyRule> getRules(HttpRequestOptions options) {
        return new CollectionPage<PropertyRule>(contextPath, PropertyRule.class, this.rules, Optional.ofNullable(rulesNextLink), Collections.emptyList(), options);
    }

    public DisplayTemplate withUnmappedField(String name, Object value) {
        DisplayTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Json layout;
        private Integer priority;
        private List<PropertyRule> rules;
        private String rulesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder layout(Json layout) {
            this.layout = layout;
            this.changedFields = changedFields.add("layout");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder rules(List<PropertyRule> rules) {
            this.rules = rules;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        public Builder rules(PropertyRule... rules) {
            return rules(Arrays.asList(rules));
        }

        public Builder rulesNextLink(String rulesNextLink) {
            this.rulesNextLink = rulesNextLink;
            this.changedFields = changedFields.add("rules");
            return this;
        }

        public DisplayTemplate build() {
            DisplayTemplate _x = new DisplayTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.externalConnectors.displayTemplate";
            _x.id = id;
            _x.layout = layout;
            _x.priority = priority;
            _x.rules = rules;
            _x.rulesNextLink = rulesNextLink;
            return _x;
        }
    }

    private DisplayTemplate _copy() {
        DisplayTemplate _x = new DisplayTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.layout = layout;
        _x.priority = priority;
        _x.rules = rules;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DisplayTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("layout=");
        b.append(this.layout);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("rules=");
        b.append(this.rules);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
