package microsoft.graph.externalconnectors.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.graph.externalconnectors.enums.AccessType;
import microsoft.graph.externalconnectors.enums.AclType;
import microsoft.graph.externalconnectors.enums.IdentitySourceType;

@JsonPropertyOrder({
    "@odata.type", 
    "accessType", 
    "identitySource", 
    "type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class Acl implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accessType")
    protected AccessType accessType;

    @JsonProperty("identitySource")
    protected IdentitySourceType identitySource;

    @JsonProperty("type")
    protected AclType type;

    @JsonProperty("value")
    protected String value;

    protected Acl() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.externalConnectors.acl";
    }

    @Property(name="accessType")
    @JsonIgnore
    public Optional<AccessType> getAccessType() {
        return Optional.ofNullable(accessType);
    }

    public Acl withAccessType(AccessType accessType) {
        Acl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.acl");
        _x.accessType = accessType;
        return _x;
    }

    @Property(name="identitySource")
    @JsonIgnore
    public Optional<IdentitySourceType> getIdentitySource() {
        return Optional.ofNullable(identitySource);
    }

    public Acl withIdentitySource(IdentitySourceType identitySource) {
        Acl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.acl");
        _x.identitySource = identitySource;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<AclType> getType() {
        return Optional.ofNullable(type);
    }

    public Acl withType(AclType type) {
        Acl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.acl");
        _x.type = type;
        return _x;
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    public Acl withValue(String value) {
        Acl _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.externalConnectors.acl");
        _x.value = value;
        return _x;
    }

    public Acl withUnmappedField(String name, Object value) {
        Acl _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AccessType accessType;
        private IdentitySourceType identitySource;
        private AclType type;
        private String value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder accessType(AccessType accessType) {
            this.accessType = accessType;
            this.changedFields = changedFields.add("accessType");
            return this;
        }

        public Builder identitySource(IdentitySourceType identitySource) {
            this.identitySource = identitySource;
            this.changedFields = changedFields.add("identitySource");
            return this;
        }

        public Builder type(AclType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Acl build() {
            Acl _x = new Acl();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.externalConnectors.acl";
            _x.accessType = accessType;
            _x.identitySource = identitySource;
            _x.type = type;
            _x.value = value;
            return _x;
        }
    }

    private Acl _copy() {
        Acl _x = new Acl();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.accessType = accessType;
        _x.identitySource = identitySource;
        _x.type = type;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Acl[");
        b.append("accessType=");
        b.append(this.accessType);
        b.append(", ");
        b.append("identitySource=");
        b.append(this.identitySource);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
