package microsoft.graph.externalconnectors.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.graph.externalconnectors.entity.ExternalItem;
import microsoft.graph.externalconnectors.entity.request.ExternalItemEntityRequest;

public class ExternalItemCollectionRequest extends CollectionPageEntityRequest<ExternalItem, ExternalItemEntityRequest>{

    protected ContextPath contextPath;

    public ExternalItemCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ExternalItem.class, cp -> new ExternalItemEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
