package microsoft.graph.externalconnectors.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.graph.externalconnectors.entity.ExternalGroup;
import microsoft.graph.externalconnectors.entity.request.ExternalGroupEntityRequest;
import microsoft.graph.externalconnectors.entity.request.IdentityEntityRequest;

public class ExternalGroupCollectionRequest extends CollectionPageEntityRequest<ExternalGroup, ExternalGroupEntityRequest>{

    protected ContextPath contextPath;

    public ExternalGroupCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ExternalGroup.class, cp -> new ExternalGroupEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public IdentityEntityRequest members(String id) {
        return new IdentityEntityRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IdentityCollectionRequest members() {
        return new IdentityCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

}
