package microsoft.graph.externalconnectors.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.graph.externalconnectors.entity.ExternalConnection;
import microsoft.graph.externalconnectors.entity.request.ConnectionOperationEntityRequest;
import microsoft.graph.externalconnectors.entity.request.ExternalConnectionEntityRequest;
import microsoft.graph.externalconnectors.entity.request.ExternalGroupEntityRequest;
import microsoft.graph.externalconnectors.entity.request.ExternalItemEntityRequest;

public class ExternalConnectionCollectionRequest extends CollectionPageEntityRequest<ExternalConnection, ExternalConnectionEntityRequest>{

    protected ContextPath contextPath;

    public ExternalConnectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ExternalConnection.class, cp -> new ExternalConnectionEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ExternalGroupEntityRequest groups(String id) {
        return new ExternalGroupEntityRequest(contextPath.addSegment("groups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalGroupCollectionRequest groups() {
        return new ExternalGroupCollectionRequest(contextPath.addSegment("groups"), Optional.empty());
    }

    public ExternalItemEntityRequest items(String id) {
        return new ExternalItemEntityRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExternalItemCollectionRequest items() {
        return new ExternalItemCollectionRequest(contextPath.addSegment("items"), Optional.empty());
    }

    public ConnectionOperationEntityRequest operations(String id) {
        return new ConnectionOperationEntityRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectionOperationCollectionRequest operations() {
        return new ConnectionOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

}
