package microsoft.graph.externalconnectors.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;

import java.lang.Object;
import java.util.Optional;

import microsoft.graph.externalconnectors.entity.ConnectionOperation;
import microsoft.graph.externalconnectors.entity.request.ConnectionOperationEntityRequest;

public class ConnectionOperationCollectionRequest extends CollectionPageEntityRequest<ConnectionOperation, ConnectionOperationEntityRequest>{

    protected ContextPath contextPath;

    public ConnectionOperationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ConnectionOperation.class, cp -> new ConnectionOperationEntityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
