package odata.msgraph.client.beta.windows.updates.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum MonitoringAction implements Enum {

    @JsonProperty("alertError")
    ALERT_ERROR("alertError", "0"),

    @JsonProperty("pauseDeployment")
    PAUSE_DEPLOYMENT("pauseDeployment", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private MonitoringAction(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
