package odata.msgraph.client.beta.windows.updates.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum EquivalentContentOption implements Enum {

    @JsonProperty("none")
    NONE("none", "0"),

    @JsonProperty("latestSecurity")
    LATEST_SECURITY("latestSecurity", "1"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "2");

    private final String name;
    private final String value;

    private EquivalentContentOption(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
