package odata.msgraph.client.beta.windows.updates.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeploymentStateValue implements Enum {

    @JsonProperty("scheduled")
    SCHEDULED("scheduled", "0"),

    @JsonProperty("offering")
    OFFERING("offering", "1"),

    @JsonProperty("paused")
    PAUSED("paused", "2"),

    @JsonProperty("faulted")
    FAULTED("faulted", "3"),

    @JsonProperty("archived")
    ARCHIVED("archived", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5");

    private final String name;
    private final String value;

    private DeploymentStateValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
