package odata.msgraph.client.beta.windows.updates.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum DeploymentStateReasonValue implements Enum {

    @JsonProperty("scheduledByOfferWindow")
    SCHEDULED_BY_OFFER_WINDOW("scheduledByOfferWindow", "0"),

    @JsonProperty("offeringByRequest")
    OFFERING_BY_REQUEST("offeringByRequest", "2"),

    @JsonProperty("pausedByRequest")
    PAUSED_BY_REQUEST("pausedByRequest", "3"),

    @JsonProperty("pausedByMonitoring")
    PAUSED_BY_MONITORING("pausedByMonitoring", "4"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "5"),

    @JsonProperty("faultedByContentOutdated")
    FAULTED_BY_CONTENT_OUTDATED("faultedByContentOutdated", "6");

    private final String name;
    private final String value;

    private DeploymentStateReasonValue(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
