package odata.msgraph.client.beta.windows.updates.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.entity.UpdatableAsset;

@JsonIgnoreType
public class UpdatableAssetRequest extends EntityRequest<UpdatableAsset> {

    public UpdatableAssetRequest(ContextPath contextPath, Optional<Object> value) {
        super(UpdatableAsset.class, contextPath, value, false);
    }

    @Action(name = "addMembers")
    @JsonIgnore
    public ActionRequestNoReturn addMembers(List<UpdatableAsset> assets) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assets", "Collection(microsoft.graph.windowsUpdates.updatableAsset)", assets)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.addMembers"), _parameters);
    }

    @Action(name = "addMembersById")
    @JsonIgnore
    public ActionRequestNoReturn addMembersById(List<String> ids, String memberEntityType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .put("memberEntityType", "Edm.String", Checks.checkIsAscii(memberEntityType))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.addMembersById"), _parameters);
    }

    @Action(name = "removeMembers")
    @JsonIgnore
    public ActionRequestNoReturn removeMembers(List<UpdatableAsset> assets) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assets", "Collection(microsoft.graph.windowsUpdates.updatableAsset)", assets)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.removeMembers"), _parameters);
    }

    @Action(name = "removeMembersById")
    @JsonIgnore
    public ActionRequestNoReturn removeMembersById(List<String> ids, String memberEntityType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .put("memberEntityType", "Edm.String", Checks.checkIsAscii(memberEntityType))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsUpdates.removeMembersById"), _parameters);
    }

}
