package odata.msgraph.client.beta.windows.updates.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.entity.UpdatableAssetGroup;
import odata.msgraph.client.beta.windows.updates.entity.collection.request.UpdatableAssetCollectionRequest;

@JsonIgnoreType
public class UpdatableAssetGroupRequest extends EntityRequest<UpdatableAssetGroup> {

    public UpdatableAssetGroupRequest(ContextPath contextPath, Optional<Object> value) {
        super(UpdatableAssetGroup.class, contextPath, value, false);
    }

    public UpdatableAssetRequest members(String id) {
        return new UpdatableAssetRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UpdatableAssetCollectionRequest members() {
        return new UpdatableAssetCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

}
