package odata.msgraph.client.beta.windows.updates.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.windows.updates.entity.collection.request.DeploymentCollectionRequest;
import odata.msgraph.client.beta.windows.updates.entity.collection.request.UpdatableAssetCollectionRequest;
import odata.msgraph.client.beta.windows.updates.entity.request.CatalogRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "catalog", 
    "deployments", 
    "updatableAssets"})
@JsonInclude(Include.NON_NULL)
public class Updates extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.updates";
    }

    @JsonProperty("catalog")
    protected Catalog catalog;

    @JsonProperty("deployments")
    protected List<Deployment> deployments;

    @JsonProperty("updatableAssets")
    protected List<UpdatableAsset> updatableAssets;

    protected Updates() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUpdates() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Catalog catalog;
        private List<Deployment> deployments;
        private List<UpdatableAsset> updatableAssets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder catalog(Catalog catalog) {
            this.catalog = catalog;
            this.changedFields = changedFields.add("catalog");
            return this;
        }

        public Builder deployments(List<Deployment> deployments) {
            this.deployments = deployments;
            this.changedFields = changedFields.add("deployments");
            return this;
        }

        public Builder deployments(Deployment... deployments) {
            return deployments(Arrays.asList(deployments));
        }

        public Builder updatableAssets(List<UpdatableAsset> updatableAssets) {
            this.updatableAssets = updatableAssets;
            this.changedFields = changedFields.add("updatableAssets");
            return this;
        }

        public Builder updatableAssets(UpdatableAsset... updatableAssets) {
            return updatableAssets(Arrays.asList(updatableAssets));
        }

        public Updates build() {
            Updates _x = new Updates();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.updates";
            _x.id = id;
            _x.catalog = catalog;
            _x.deployments = deployments;
            _x.updatableAssets = updatableAssets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Updates withUnmappedField(String name, Object value) {
        Updates _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="catalog")
    @JsonIgnore
    public CatalogRequest getCatalog() {
        return new CatalogRequest(contextPath.addSegment("catalog"), Optional.ofNullable(catalog));
    }

    @NavigationProperty(name="deployments")
    @JsonIgnore
    public DeploymentCollectionRequest getDeployments() {
        return new DeploymentCollectionRequest(
                        contextPath.addSegment("deployments"), Optional.ofNullable(deployments));
    }

    @NavigationProperty(name="updatableAssets")
    @JsonIgnore
    public UpdatableAssetCollectionRequest getUpdatableAssets() {
        return new UpdatableAssetCollectionRequest(
                        contextPath.addSegment("updatableAssets"), Optional.ofNullable(updatableAssets));
    }

    public Updates withCatalog(Catalog catalog) {
        Updates _x = _copy();
        _x.changedFields = changedFields.add("catalog");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.updates");
        _x.catalog = catalog;
        return _x;
    }

    public Updates withDeployments(List<Deployment> deployments) {
        Updates _x = _copy();
        _x.changedFields = changedFields.add("deployments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.updates");
        _x.deployments = deployments;
        return _x;
    }

    public Updates withUpdatableAssets(List<UpdatableAsset> updatableAssets) {
        Updates _x = _copy();
        _x.changedFields = changedFields.add("updatableAssets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.updates");
        _x.updatableAssets = updatableAssets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Updates patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Updates _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Updates put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Updates _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Updates _copy() {
        Updates _x = new Updates();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.catalog = catalog;
        _x.deployments = deployments;
        _x.updatableAssets = updatableAssets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Updates[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("catalog=");
        b.append(this.catalog);
        b.append(", ");
        b.append("deployments=");
        b.append(this.deployments);
        b.append(", ");
        b.append("updatableAssets=");
        b.append(this.updatableAssets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
