package odata.msgraph.client.beta.windows.updates.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.enums.QualityUpdateClassification;

@JsonPropertyOrder({
    "@odata.type", 
    "isExpeditable", 
    "qualityUpdateClassification"})
@JsonInclude(Include.NON_NULL)
public class QualityUpdateCatalogEntry extends SoftwareUpdateCatalogEntry implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.qualityUpdateCatalogEntry";
    }

    @JsonProperty("isExpeditable")
    protected Boolean isExpeditable;

    @JsonProperty("qualityUpdateClassification")
    protected QualityUpdateClassification qualityUpdateClassification;

    protected QualityUpdateCatalogEntry() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderQualityUpdateCatalogEntry() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deployableUntilDateTime;
        private String displayName;
        private OffsetDateTime releaseDateTime;
        private Boolean isExpeditable;
        private QualityUpdateClassification qualityUpdateClassification;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deployableUntilDateTime(OffsetDateTime deployableUntilDateTime) {
            this.deployableUntilDateTime = deployableUntilDateTime;
            this.changedFields = changedFields.add("deployableUntilDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder releaseDateTime(OffsetDateTime releaseDateTime) {
            this.releaseDateTime = releaseDateTime;
            this.changedFields = changedFields.add("releaseDateTime");
            return this;
        }

        public Builder isExpeditable(Boolean isExpeditable) {
            this.isExpeditable = isExpeditable;
            this.changedFields = changedFields.add("isExpeditable");
            return this;
        }

        public Builder qualityUpdateClassification(QualityUpdateClassification qualityUpdateClassification) {
            this.qualityUpdateClassification = qualityUpdateClassification;
            this.changedFields = changedFields.add("qualityUpdateClassification");
            return this;
        }

        public QualityUpdateCatalogEntry build() {
            QualityUpdateCatalogEntry _x = new QualityUpdateCatalogEntry();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.qualityUpdateCatalogEntry";
            _x.id = id;
            _x.deployableUntilDateTime = deployableUntilDateTime;
            _x.displayName = displayName;
            _x.releaseDateTime = releaseDateTime;
            _x.isExpeditable = isExpeditable;
            _x.qualityUpdateClassification = qualityUpdateClassification;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isExpeditable")
    @JsonIgnore
    public Optional<Boolean> getIsExpeditable() {
        return Optional.ofNullable(isExpeditable);
    }

    public QualityUpdateCatalogEntry withIsExpeditable(Boolean isExpeditable) {
        QualityUpdateCatalogEntry _x = _copy();
        _x.changedFields = changedFields.add("isExpeditable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.qualityUpdateCatalogEntry");
        _x.isExpeditable = isExpeditable;
        return _x;
    }

    @Property(name="qualityUpdateClassification")
    @JsonIgnore
    public Optional<QualityUpdateClassification> getQualityUpdateClassification() {
        return Optional.ofNullable(qualityUpdateClassification);
    }

    public QualityUpdateCatalogEntry withQualityUpdateClassification(QualityUpdateClassification qualityUpdateClassification) {
        QualityUpdateCatalogEntry _x = _copy();
        _x.changedFields = changedFields.add("qualityUpdateClassification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.qualityUpdateCatalogEntry");
        _x.qualityUpdateClassification = qualityUpdateClassification;
        return _x;
    }

    public QualityUpdateCatalogEntry withUnmappedField(String name, Object value) {
        QualityUpdateCatalogEntry _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public QualityUpdateCatalogEntry patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        QualityUpdateCatalogEntry _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public QualityUpdateCatalogEntry put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        QualityUpdateCatalogEntry _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private QualityUpdateCatalogEntry _copy() {
        QualityUpdateCatalogEntry _x = new QualityUpdateCatalogEntry();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deployableUntilDateTime = deployableUntilDateTime;
        _x.displayName = displayName;
        _x.releaseDateTime = releaseDateTime;
        _x.isExpeditable = isExpeditable;
        _x.qualityUpdateClassification = qualityUpdateClassification;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QualityUpdateCatalogEntry[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deployableUntilDateTime=");
        b.append(this.deployableUntilDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("releaseDateTime=");
        b.append(this.releaseDateTime);
        b.append(", ");
        b.append("isExpeditable=");
        b.append(this.isExpeditable);
        b.append(", ");
        b.append("qualityUpdateClassification=");
        b.append(this.qualityUpdateClassification);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
