package odata.msgraph.client.beta.windows.updates.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;

@JsonPropertyOrder({
    "@odata.type", 
    "deployableUntilDateTime", 
    "displayName", 
    "releaseDateTime"})
@JsonInclude(Include.NON_NULL)
public class CatalogEntry extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.catalogEntry";
    }

    @JsonProperty("deployableUntilDateTime")
    protected OffsetDateTime deployableUntilDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("releaseDateTime")
    protected OffsetDateTime releaseDateTime;

    protected CatalogEntry() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="deployableUntilDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeployableUntilDateTime() {
        return Optional.ofNullable(deployableUntilDateTime);
    }

    public CatalogEntry withDeployableUntilDateTime(OffsetDateTime deployableUntilDateTime) {
        CatalogEntry _x = _copy();
        _x.changedFields = changedFields.add("deployableUntilDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.catalogEntry");
        _x.deployableUntilDateTime = deployableUntilDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CatalogEntry withDisplayName(String displayName) {
        CatalogEntry _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.catalogEntry");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="releaseDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReleaseDateTime() {
        return Optional.ofNullable(releaseDateTime);
    }

    public CatalogEntry withReleaseDateTime(OffsetDateTime releaseDateTime) {
        CatalogEntry _x = _copy();
        _x.changedFields = changedFields.add("releaseDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.catalogEntry");
        _x.releaseDateTime = releaseDateTime;
        return _x;
    }

    public CatalogEntry withUnmappedField(String name, Object value) {
        CatalogEntry _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CatalogEntry patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CatalogEntry _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CatalogEntry put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CatalogEntry _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CatalogEntry _copy() {
        CatalogEntry _x = new CatalogEntry();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deployableUntilDateTime = deployableUntilDateTime;
        _x.displayName = displayName;
        _x.releaseDateTime = releaseDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CatalogEntry[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deployableUntilDateTime=");
        b.append(this.deployableUntilDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("releaseDateTime=");
        b.append(this.releaseDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
