package odata.msgraph.client.beta.windows.updates.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.complex.UpdatableAssetEnrollment;
import odata.msgraph.client.beta.windows.updates.complex.UpdatableAssetError;

@JsonPropertyOrder({
    "@odata.type", 
    "enrollments", 
    "errors"})
@JsonInclude(Include.NON_NULL)
public class AzureADDevice extends UpdatableAsset implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.azureADDevice";
    }

    @JsonProperty("enrollments")
    protected List<UpdatableAssetEnrollment> enrollments;

    @JsonProperty("enrollments@nextLink")
    protected String enrollmentsNextLink;

    @JsonProperty("errors")
    protected List<UpdatableAssetError> errors;

    @JsonProperty("errors@nextLink")
    protected String errorsNextLink;

    protected AzureADDevice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAzureADDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<UpdatableAssetEnrollment> enrollments;
        private String enrollmentsNextLink;
        private List<UpdatableAssetError> errors;
        private String errorsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder enrollments(List<UpdatableAssetEnrollment> enrollments) {
            this.enrollments = enrollments;
            this.changedFields = changedFields.add("enrollments");
            return this;
        }

        public Builder enrollments(UpdatableAssetEnrollment... enrollments) {
            return enrollments(Arrays.asList(enrollments));
        }

        public Builder enrollmentsNextLink(String enrollmentsNextLink) {
            this.enrollmentsNextLink = enrollmentsNextLink;
            this.changedFields = changedFields.add("enrollments");
            return this;
        }

        public Builder errors(List<UpdatableAssetError> errors) {
            this.errors = errors;
            this.changedFields = changedFields.add("errors");
            return this;
        }

        public Builder errors(UpdatableAssetError... errors) {
            return errors(Arrays.asList(errors));
        }

        public Builder errorsNextLink(String errorsNextLink) {
            this.errorsNextLink = errorsNextLink;
            this.changedFields = changedFields.add("errors");
            return this;
        }

        public AzureADDevice build() {
            AzureADDevice _x = new AzureADDevice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.azureADDevice";
            _x.id = id;
            _x.enrollments = enrollments;
            _x.enrollmentsNextLink = enrollmentsNextLink;
            _x.errors = errors;
            _x.errorsNextLink = errorsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="enrollments")
    @JsonIgnore
    public CollectionPage<UpdatableAssetEnrollment> getEnrollments() {
        return new CollectionPage<UpdatableAssetEnrollment>(contextPath, UpdatableAssetEnrollment.class, this.enrollments, Optional.ofNullable(enrollmentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AzureADDevice withEnrollments(List<UpdatableAssetEnrollment> enrollments) {
        AzureADDevice _x = _copy();
        _x.changedFields = changedFields.add("enrollments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.azureADDevice");
        _x.enrollments = enrollments;
        return _x;
    }

    @Property(name="enrollments")
    @JsonIgnore
    public CollectionPage<UpdatableAssetEnrollment> getEnrollments(HttpRequestOptions options) {
        return new CollectionPage<UpdatableAssetEnrollment>(contextPath, UpdatableAssetEnrollment.class, this.enrollments, Optional.ofNullable(enrollmentsNextLink), Collections.emptyList(), options);
    }

    @Property(name="errors")
    @JsonIgnore
    public CollectionPage<UpdatableAssetError> getErrors() {
        return new CollectionPage<UpdatableAssetError>(contextPath, UpdatableAssetError.class, this.errors, Optional.ofNullable(errorsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AzureADDevice withErrors(List<UpdatableAssetError> errors) {
        AzureADDevice _x = _copy();
        _x.changedFields = changedFields.add("errors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.azureADDevice");
        _x.errors = errors;
        return _x;
    }

    @Property(name="errors")
    @JsonIgnore
    public CollectionPage<UpdatableAssetError> getErrors(HttpRequestOptions options) {
        return new CollectionPage<UpdatableAssetError>(contextPath, UpdatableAssetError.class, this.errors, Optional.ofNullable(errorsNextLink), Collections.emptyList(), options);
    }

    public AzureADDevice withUnmappedField(String name, Object value) {
        AzureADDevice _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADDevice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AzureADDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADDevice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AzureADDevice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AzureADDevice _copy() {
        AzureADDevice _x = new AzureADDevice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.enrollments = enrollments;
        _x.errors = errors;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AzureADDevice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("enrollments=");
        b.append(this.enrollments);
        b.append(", ");
        b.append("errors=");
        b.append(this.errors);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
