package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.enums.UpdateCategory;

@JsonPropertyOrder({
    "@odata.type", 
    "updateCategory"})
@JsonInclude(Include.NON_NULL)
public class UpdateManagementEnrollment extends UpdatableAssetEnrollment implements ODataType {

    @JsonProperty("updateCategory")
    protected UpdateCategory updateCategory;

    protected UpdateManagementEnrollment() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.updateManagementEnrollment";
    }

    @Property(name="updateCategory")
    @JsonIgnore
    public Optional<UpdateCategory> getUpdateCategory() {
        return Optional.ofNullable(updateCategory);
    }

    public UpdateManagementEnrollment withUpdateCategory(UpdateCategory updateCategory) {
        UpdateManagementEnrollment _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.updateManagementEnrollment");
        _x.updateCategory = updateCategory;
        return _x;
    }

    public UpdateManagementEnrollment withUnmappedField(String name, Object value) {
        UpdateManagementEnrollment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUpdateManagementEnrollment() {
        return new Builder();
    }

    public static final class Builder {
        private UpdateCategory updateCategory;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder updateCategory(UpdateCategory updateCategory) {
            this.updateCategory = updateCategory;
            this.changedFields = changedFields.add("updateCategory");
            return this;
        }

        public UpdateManagementEnrollment build() {
            UpdateManagementEnrollment _x = new UpdateManagementEnrollment();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.updateManagementEnrollment";
            _x.updateCategory = updateCategory;
            return _x;
        }
    }

    private UpdateManagementEnrollment _copy() {
        UpdateManagementEnrollment _x = new UpdateManagementEnrollment();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.updateCategory = updateCategory;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UpdateManagementEnrollment[");
        b.append("updateCategory=");
        b.append(this.updateCategory);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
