package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.enums.EquivalentContentOption;
import odata.msgraph.client.beta.windows.updates.enums.QualityUpdateClassification;

@JsonPropertyOrder({
    "@odata.type", 
    "equivalentContent"})
@JsonInclude(Include.NON_NULL)
public class ExpeditedQualityUpdateReference extends QualityUpdateReference implements ODataType {

    @JsonProperty("equivalentContent")
    protected EquivalentContentOption equivalentContent;

    protected ExpeditedQualityUpdateReference() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.expeditedQualityUpdateReference";
    }

    @Property(name="equivalentContent")
    @JsonIgnore
    public Optional<EquivalentContentOption> getEquivalentContent() {
        return Optional.ofNullable(equivalentContent);
    }

    public ExpeditedQualityUpdateReference withEquivalentContent(EquivalentContentOption equivalentContent) {
        ExpeditedQualityUpdateReference _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.expeditedQualityUpdateReference");
        _x.equivalentContent = equivalentContent;
        return _x;
    }

    public ExpeditedQualityUpdateReference withUnmappedField(String name, Object value) {
        ExpeditedQualityUpdateReference _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExpeditedQualityUpdateReference() {
        return new Builder();
    }

    public static final class Builder {
        private QualityUpdateClassification classification;
        private OffsetDateTime releaseDateTime;
        private EquivalentContentOption equivalentContent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder classification(QualityUpdateClassification classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder releaseDateTime(OffsetDateTime releaseDateTime) {
            this.releaseDateTime = releaseDateTime;
            this.changedFields = changedFields.add("releaseDateTime");
            return this;
        }

        public Builder equivalentContent(EquivalentContentOption equivalentContent) {
            this.equivalentContent = equivalentContent;
            this.changedFields = changedFields.add("equivalentContent");
            return this;
        }

        public ExpeditedQualityUpdateReference build() {
            ExpeditedQualityUpdateReference _x = new ExpeditedQualityUpdateReference();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.expeditedQualityUpdateReference";
            _x.classification = classification;
            _x.releaseDateTime = releaseDateTime;
            _x.equivalentContent = equivalentContent;
            return _x;
        }
    }

    private ExpeditedQualityUpdateReference _copy() {
        ExpeditedQualityUpdateReference _x = new ExpeditedQualityUpdateReference();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.classification = classification;
        _x.releaseDateTime = releaseDateTime;
        _x.equivalentContent = equivalentContent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExpeditedQualityUpdateReference[");
        b.append("classification=");
        b.append(this.classification);
        b.append(", ");
        b.append("releaseDateTime=");
        b.append(this.releaseDateTime);
        b.append(", ");
        b.append("equivalentContent=");
        b.append(this.equivalentContent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
