package odata.msgraph.client.beta.windows.updates.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.windows.updates.enums.AzureADDeviceRegistrationErrorReason;

@JsonPropertyOrder({
    "@odata.type", 
    "reason"})
@JsonInclude(Include.NON_NULL)
public class AzureADDeviceRegistrationError extends UpdatableAssetError implements ODataType {

    @JsonProperty("reason")
    protected AzureADDeviceRegistrationErrorReason reason;

    protected AzureADDeviceRegistrationError() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.windowsUpdates.azureADDeviceRegistrationError";
    }

    @Property(name="reason")
    @JsonIgnore
    public Optional<AzureADDeviceRegistrationErrorReason> getReason() {
        return Optional.ofNullable(reason);
    }

    public AzureADDeviceRegistrationError withReason(AzureADDeviceRegistrationErrorReason reason) {
        AzureADDeviceRegistrationError _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.windowsUpdates.azureADDeviceRegistrationError");
        _x.reason = reason;
        return _x;
    }

    public AzureADDeviceRegistrationError withUnmappedField(String name, Object value) {
        AzureADDeviceRegistrationError _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAzureADDeviceRegistrationError() {
        return new Builder();
    }

    public static final class Builder {
        private AzureADDeviceRegistrationErrorReason reason;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder reason(AzureADDeviceRegistrationErrorReason reason) {
            this.reason = reason;
            this.changedFields = changedFields.add("reason");
            return this;
        }

        public AzureADDeviceRegistrationError build() {
            AzureADDeviceRegistrationError _x = new AzureADDeviceRegistrationError();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.windowsUpdates.azureADDeviceRegistrationError";
            _x.reason = reason;
            return _x;
        }
    }

    private AzureADDeviceRegistrationError _copy() {
        AzureADDeviceRegistrationError _x = new AzureADDeviceRegistrationError();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.reason = reason;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AzureADDeviceRegistrationError[");
        b.append("reason=");
        b.append(this.reason);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
