package odata.msgraph.client.beta.termStore.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.termStore.entity.Term;
import odata.msgraph.client.beta.termStore.entity.collection.request.RelationCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.collection.request.TermCollectionRequest;

@JsonIgnoreType
public class TermRequest extends EntityRequest<Term> {

    public TermRequest(ContextPath contextPath, Optional<Object> value) {
        super(Term.class, contextPath, value, false);
    }

    public TermRequest children(String id) {
        return new TermRequest(contextPath.addSegment("children").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermCollectionRequest children() {
        return new TermCollectionRequest(
                        contextPath.addSegment("children"), Optional.empty());
    }

    public RelationRequest relations(String id) {
        return new RelationRequest(contextPath.addSegment("relations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RelationCollectionRequest relations() {
        return new RelationCollectionRequest(
                        contextPath.addSegment("relations"), Optional.empty());
    }

    public SetRequest set() {
        return new SetRequest(contextPath.addSegment("set"), Optional.empty());
    }

}
