package odata.msgraph.client.beta.termStore.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.termStore.entity.Relation;

@JsonIgnoreType
public class RelationRequest extends EntityRequest<Relation> {

    public RelationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Relation.class, contextPath, value, false);
    }

    public TermRequest fromTerm() {
        return new TermRequest(contextPath.addSegment("fromTerm"), Optional.empty());
    }

    public SetRequest set() {
        return new SetRequest(contextPath.addSegment("set"), Optional.empty());
    }

    public TermRequest toTerm() {
        return new TermRequest(contextPath.addSegment("toTerm"), Optional.empty());
    }

}
