package odata.msgraph.client.beta.termStore.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.termStore.entity.Set;
import odata.msgraph.client.beta.termStore.entity.request.RelationRequest;
import odata.msgraph.client.beta.termStore.entity.request.SetRequest;
import odata.msgraph.client.beta.termStore.entity.request.TermRequest;

public class SetCollectionRequest extends CollectionPageEntityRequest<Set, SetRequest>{

    protected ContextPath contextPath;

    public SetCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Set.class, cp -> new SetRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TermRequest children(String id) {
        return new TermRequest(contextPath.addSegment("children").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermCollectionRequest children() {
        return new TermCollectionRequest(contextPath.addSegment("children"), Optional.empty());
    }

    public RelationRequest relations(String id) {
        return new RelationRequest(contextPath.addSegment("relations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RelationCollectionRequest relations() {
        return new RelationCollectionRequest(contextPath.addSegment("relations"), Optional.empty());
    }

    public TermRequest terms(String id) {
        return new TermRequest(contextPath.addSegment("terms").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermCollectionRequest terms() {
        return new TermCollectionRequest(contextPath.addSegment("terms"), Optional.empty());
    }

}
