package odata.msgraph.client.beta.termStore.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.termStore.entity.Group;
import odata.msgraph.client.beta.termStore.entity.request.GroupRequest;
import odata.msgraph.client.beta.termStore.entity.request.SetRequest;

public class GroupCollectionRequest extends CollectionPageEntityRequest<Group, GroupRequest>{

    protected ContextPath contextPath;

    public GroupCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Group.class, cp -> new GroupRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SetRequest sets(String id) {
        return new SetRequest(contextPath.addSegment("sets").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SetCollectionRequest sets() {
        return new SetCollectionRequest(contextPath.addSegment("sets"), Optional.empty());
    }

}
