package odata.msgraph.client.beta.termStore.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.termStore.complex.LocalizedDescription;
import odata.msgraph.client.beta.termStore.complex.LocalizedLabel;
import odata.msgraph.client.beta.termStore.entity.collection.request.RelationCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.collection.request.TermCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.request.SetRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "descriptions", 
    "labels", 
    "lastModifiedDateTime", 
    "properties", 
    "children", 
    "relations"})
@JsonInclude(Include.NON_NULL)
public class Term extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termStore.term";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("descriptions")
    protected List<LocalizedDescription> descriptions;

    @JsonProperty("descriptions@nextLink")
    protected String descriptionsNextLink;

    @JsonProperty("labels")
    protected List<LocalizedLabel> labels;

    @JsonProperty("labels@nextLink")
    protected String labelsNextLink;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("properties")
    protected List<KeyValue> properties;

    @JsonProperty("properties@nextLink")
    protected String propertiesNextLink;

    @JsonProperty("children")
    protected List<Term> children;

    @JsonProperty("relations")
    protected List<Relation> relations;

    protected Term() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTerm() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private List<LocalizedDescription> descriptions;
        private String descriptionsNextLink;
        private List<LocalizedLabel> labels;
        private String labelsNextLink;
        private OffsetDateTime lastModifiedDateTime;
        private List<KeyValue> properties;
        private String propertiesNextLink;
        private List<Term> children;
        private List<Relation> relations;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder descriptions(List<LocalizedDescription> descriptions) {
            this.descriptions = descriptions;
            this.changedFields = changedFields.add("descriptions");
            return this;
        }

        public Builder descriptions(LocalizedDescription... descriptions) {
            return descriptions(Arrays.asList(descriptions));
        }

        public Builder descriptionsNextLink(String descriptionsNextLink) {
            this.descriptionsNextLink = descriptionsNextLink;
            this.changedFields = changedFields.add("descriptions");
            return this;
        }

        public Builder labels(List<LocalizedLabel> labels) {
            this.labels = labels;
            this.changedFields = changedFields.add("labels");
            return this;
        }

        public Builder labels(LocalizedLabel... labels) {
            return labels(Arrays.asList(labels));
        }

        public Builder labelsNextLink(String labelsNextLink) {
            this.labelsNextLink = labelsNextLink;
            this.changedFields = changedFields.add("labels");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder properties(List<KeyValue> properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder properties(KeyValue... properties) {
            return properties(Arrays.asList(properties));
        }

        public Builder propertiesNextLink(String propertiesNextLink) {
            this.propertiesNextLink = propertiesNextLink;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder children(List<Term> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        public Builder children(Term... children) {
            return children(Arrays.asList(children));
        }

        public Builder relations(List<Relation> relations) {
            this.relations = relations;
            this.changedFields = changedFields.add("relations");
            return this;
        }

        public Builder relations(Relation... relations) {
            return relations(Arrays.asList(relations));
        }

        public Term build() {
            Term _x = new Term();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termStore.term";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.descriptions = descriptions;
            _x.descriptionsNextLink = descriptionsNextLink;
            _x.labels = labels;
            _x.labelsNextLink = labelsNextLink;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.properties = properties;
            _x.propertiesNextLink = propertiesNextLink;
            _x.children = children;
            _x.relations = relations;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Term withCreatedDateTime(OffsetDateTime createdDateTime) {
        Term _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.term");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="descriptions")
    @JsonIgnore
    public CollectionPage<LocalizedDescription> getDescriptions() {
        return new CollectionPage<LocalizedDescription>(contextPath, LocalizedDescription.class, this.descriptions, Optional.ofNullable(descriptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Term withDescriptions(List<LocalizedDescription> descriptions) {
        Term _x = _copy();
        _x.changedFields = changedFields.add("descriptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.term");
        _x.descriptions = descriptions;
        return _x;
    }

    @Property(name="descriptions")
    @JsonIgnore
    public CollectionPage<LocalizedDescription> getDescriptions(HttpRequestOptions options) {
        return new CollectionPage<LocalizedDescription>(contextPath, LocalizedDescription.class, this.descriptions, Optional.ofNullable(descriptionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="labels")
    @JsonIgnore
    public CollectionPage<LocalizedLabel> getLabels() {
        return new CollectionPage<LocalizedLabel>(contextPath, LocalizedLabel.class, this.labels, Optional.ofNullable(labelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Term withLabels(List<LocalizedLabel> labels) {
        Term _x = _copy();
        _x.changedFields = changedFields.add("labels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.term");
        _x.labels = labels;
        return _x;
    }

    @Property(name="labels")
    @JsonIgnore
    public CollectionPage<LocalizedLabel> getLabels(HttpRequestOptions options) {
        return new CollectionPage<LocalizedLabel>(contextPath, LocalizedLabel.class, this.labels, Optional.ofNullable(labelsNextLink), Collections.emptyList(), options);
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Term withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Term _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.term");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<KeyValue> getProperties() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.properties, Optional.ofNullable(propertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Term withProperties(List<KeyValue> properties) {
        Term _x = _copy();
        _x.changedFields = changedFields.add("properties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.term");
        _x.properties = properties;
        return _x;
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<KeyValue> getProperties(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.properties, Optional.ofNullable(propertiesNextLink), Collections.emptyList(), options);
    }

    public Term withUnmappedField(String name, Object value) {
        Term _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="children")
    @JsonIgnore
    public TermCollectionRequest getChildren() {
        return new TermCollectionRequest(
                        contextPath.addSegment("children"), Optional.ofNullable(children));
    }

    @NavigationProperty(name="relations")
    @JsonIgnore
    public RelationCollectionRequest getRelations() {
        return new RelationCollectionRequest(
                        contextPath.addSegment("relations"), Optional.ofNullable(relations));
    }

    @NavigationProperty(name="set")
    @JsonIgnore
    public SetRequest getSet() {
        return new SetRequest(contextPath.addSegment("set"), RequestHelper.getValue(unmappedFields, "set"));
    }

    public Term withChildren(List<Term> children) {
        Term _x = _copy();
        _x.changedFields = changedFields.add("children");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.term");
        _x.children = children;
        return _x;
    }

    public Term withRelations(List<Relation> relations) {
        Term _x = _copy();
        _x.changedFields = changedFields.add("relations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.term");
        _x.relations = relations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Term patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Term _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Term put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Term _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Term _copy() {
        Term _x = new Term();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.descriptions = descriptions;
        _x.labels = labels;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.properties = properties;
        _x.children = children;
        _x.relations = relations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Term[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("descriptions=");
        b.append(this.descriptions);
        b.append(", ");
        b.append("labels=");
        b.append(this.labels);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("properties=");
        b.append(this.properties);
        b.append(", ");
        b.append("children=");
        b.append(this.children);
        b.append(", ");
        b.append("relations=");
        b.append(this.relations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
