package odata.msgraph.client.beta.termStore.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.termStore.entity.collection.request.GroupCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.collection.request.SetCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "defaultLanguageTag", 
    "languageTags", 
    "groups", 
    "sets"})
@JsonInclude(Include.NON_NULL)
public class Store extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termStore.store";
    }

    @JsonProperty("defaultLanguageTag")
    protected String defaultLanguageTag;

    @JsonProperty("languageTags")
    protected List<String> languageTags;

    @JsonProperty("languageTags@nextLink")
    protected String languageTagsNextLink;

    @JsonProperty("groups")
    protected List<Group> groups;

    @JsonProperty("sets")
    protected List<Set> sets;

    protected Store() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderStore() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String defaultLanguageTag;
        private List<String> languageTags;
        private String languageTagsNextLink;
        private List<Group> groups;
        private List<Set> sets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder defaultLanguageTag(String defaultLanguageTag) {
            this.defaultLanguageTag = defaultLanguageTag;
            this.changedFields = changedFields.add("defaultLanguageTag");
            return this;
        }

        public Builder languageTags(List<String> languageTags) {
            this.languageTags = languageTags;
            this.changedFields = changedFields.add("languageTags");
            return this;
        }

        public Builder languageTags(String... languageTags) {
            return languageTags(Arrays.asList(languageTags));
        }

        public Builder languageTagsNextLink(String languageTagsNextLink) {
            this.languageTagsNextLink = languageTagsNextLink;
            this.changedFields = changedFields.add("languageTags");
            return this;
        }

        public Builder groups(List<Group> groups) {
            this.groups = groups;
            this.changedFields = changedFields.add("groups");
            return this;
        }

        public Builder groups(Group... groups) {
            return groups(Arrays.asList(groups));
        }

        public Builder sets(List<Set> sets) {
            this.sets = sets;
            this.changedFields = changedFields.add("sets");
            return this;
        }

        public Builder sets(Set... sets) {
            return sets(Arrays.asList(sets));
        }

        public Store build() {
            Store _x = new Store();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termStore.store";
            _x.id = id;
            _x.defaultLanguageTag = defaultLanguageTag;
            _x.languageTags = languageTags;
            _x.languageTagsNextLink = languageTagsNextLink;
            _x.groups = groups;
            _x.sets = sets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="defaultLanguageTag")
    @JsonIgnore
    public Optional<String> getDefaultLanguageTag() {
        return Optional.ofNullable(defaultLanguageTag);
    }

    public Store withDefaultLanguageTag(String defaultLanguageTag) {
        Store _x = _copy();
        _x.changedFields = changedFields.add("defaultLanguageTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.store");
        _x.defaultLanguageTag = defaultLanguageTag;
        return _x;
    }

    @Property(name="languageTags")
    @JsonIgnore
    public CollectionPage<String> getLanguageTags() {
        return new CollectionPage<String>(contextPath, String.class, this.languageTags, Optional.ofNullable(languageTagsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Store withLanguageTags(List<String> languageTags) {
        Store _x = _copy();
        _x.changedFields = changedFields.add("languageTags");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.store");
        _x.languageTags = languageTags;
        return _x;
    }

    @Property(name="languageTags")
    @JsonIgnore
    public CollectionPage<String> getLanguageTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.languageTags, Optional.ofNullable(languageTagsNextLink), Collections.emptyList(), options);
    }

    public Store withUnmappedField(String name, Object value) {
        Store _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="groups")
    @JsonIgnore
    public GroupCollectionRequest getGroups() {
        return new GroupCollectionRequest(
                        contextPath.addSegment("groups"), Optional.ofNullable(groups));
    }

    @NavigationProperty(name="sets")
    @JsonIgnore
    public SetCollectionRequest getSets() {
        return new SetCollectionRequest(
                        contextPath.addSegment("sets"), Optional.ofNullable(sets));
    }

    public Store withGroups(List<Group> groups) {
        Store _x = _copy();
        _x.changedFields = changedFields.add("groups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.store");
        _x.groups = groups;
        return _x;
    }

    public Store withSets(List<Set> sets) {
        Store _x = _copy();
        _x.changedFields = changedFields.add("sets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.store");
        _x.sets = sets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Store patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Store _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Store put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Store _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Store _copy() {
        Store _x = new Store();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.defaultLanguageTag = defaultLanguageTag;
        _x.languageTags = languageTags;
        _x.groups = groups;
        _x.sets = sets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Store[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("defaultLanguageTag=");
        b.append(this.defaultLanguageTag);
        b.append(", ");
        b.append("languageTags=");
        b.append(this.languageTags);
        b.append(", ");
        b.append("groups=");
        b.append(this.groups);
        b.append(", ");
        b.append("sets=");
        b.append(this.sets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
