package odata.msgraph.client.beta.termStore.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.termStore.complex.LocalizedName;
import odata.msgraph.client.beta.termStore.entity.collection.request.RelationCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.collection.request.TermCollectionRequest;
import odata.msgraph.client.beta.termStore.entity.request.GroupRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "localizedNames", 
    "properties", 
    "children", 
    "parentGroup", 
    "relations", 
    "terms"})
@JsonInclude(Include.NON_NULL)
public class Set extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termStore.set";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("localizedNames")
    protected List<LocalizedName> localizedNames;

    @JsonProperty("localizedNames@nextLink")
    protected String localizedNamesNextLink;

    @JsonProperty("properties")
    protected List<KeyValue> properties;

    @JsonProperty("properties@nextLink")
    protected String propertiesNextLink;

    @JsonProperty("children")
    protected List<Term> children;

    @JsonProperty("parentGroup")
    protected Group parentGroup;

    @JsonProperty("relations")
    protected List<Relation> relations;

    @JsonProperty("terms")
    protected List<Term> terms;

    protected Set() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private List<LocalizedName> localizedNames;
        private String localizedNamesNextLink;
        private List<KeyValue> properties;
        private String propertiesNextLink;
        private List<Term> children;
        private Group parentGroup;
        private List<Relation> relations;
        private List<Term> terms;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder localizedNames(List<LocalizedName> localizedNames) {
            this.localizedNames = localizedNames;
            this.changedFields = changedFields.add("localizedNames");
            return this;
        }

        public Builder localizedNames(LocalizedName... localizedNames) {
            return localizedNames(Arrays.asList(localizedNames));
        }

        public Builder localizedNamesNextLink(String localizedNamesNextLink) {
            this.localizedNamesNextLink = localizedNamesNextLink;
            this.changedFields = changedFields.add("localizedNames");
            return this;
        }

        public Builder properties(List<KeyValue> properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder properties(KeyValue... properties) {
            return properties(Arrays.asList(properties));
        }

        public Builder propertiesNextLink(String propertiesNextLink) {
            this.propertiesNextLink = propertiesNextLink;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder children(List<Term> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        public Builder children(Term... children) {
            return children(Arrays.asList(children));
        }

        public Builder parentGroup(Group parentGroup) {
            this.parentGroup = parentGroup;
            this.changedFields = changedFields.add("parentGroup");
            return this;
        }

        public Builder relations(List<Relation> relations) {
            this.relations = relations;
            this.changedFields = changedFields.add("relations");
            return this;
        }

        public Builder relations(Relation... relations) {
            return relations(Arrays.asList(relations));
        }

        public Builder terms(List<Term> terms) {
            this.terms = terms;
            this.changedFields = changedFields.add("terms");
            return this;
        }

        public Builder terms(Term... terms) {
            return terms(Arrays.asList(terms));
        }

        public Set build() {
            Set _x = new Set();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termStore.set";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.localizedNames = localizedNames;
            _x.localizedNamesNextLink = localizedNamesNextLink;
            _x.properties = properties;
            _x.propertiesNextLink = propertiesNextLink;
            _x.children = children;
            _x.parentGroup = parentGroup;
            _x.relations = relations;
            _x.terms = terms;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Set withCreatedDateTime(OffsetDateTime createdDateTime) {
        Set _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.set");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Set withDescription(String description) {
        Set _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.set");
        _x.description = description;
        return _x;
    }

    @Property(name="localizedNames")
    @JsonIgnore
    public CollectionPage<LocalizedName> getLocalizedNames() {
        return new CollectionPage<LocalizedName>(contextPath, LocalizedName.class, this.localizedNames, Optional.ofNullable(localizedNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Set withLocalizedNames(List<LocalizedName> localizedNames) {
        Set _x = _copy();
        _x.changedFields = changedFields.add("localizedNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.set");
        _x.localizedNames = localizedNames;
        return _x;
    }

    @Property(name="localizedNames")
    @JsonIgnore
    public CollectionPage<LocalizedName> getLocalizedNames(HttpRequestOptions options) {
        return new CollectionPage<LocalizedName>(contextPath, LocalizedName.class, this.localizedNames, Optional.ofNullable(localizedNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<KeyValue> getProperties() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.properties, Optional.ofNullable(propertiesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Set withProperties(List<KeyValue> properties) {
        Set _x = _copy();
        _x.changedFields = changedFields.add("properties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.set");
        _x.properties = properties;
        return _x;
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<KeyValue> getProperties(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.properties, Optional.ofNullable(propertiesNextLink), Collections.emptyList(), options);
    }

    public Set withUnmappedField(String name, Object value) {
        Set _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="children")
    @JsonIgnore
    public TermCollectionRequest getChildren() {
        return new TermCollectionRequest(
                        contextPath.addSegment("children"), Optional.ofNullable(children));
    }

    @NavigationProperty(name="parentGroup")
    @JsonIgnore
    public GroupRequest getParentGroup() {
        return new GroupRequest(contextPath.addSegment("parentGroup"), Optional.ofNullable(parentGroup));
    }

    @NavigationProperty(name="relations")
    @JsonIgnore
    public RelationCollectionRequest getRelations() {
        return new RelationCollectionRequest(
                        contextPath.addSegment("relations"), Optional.ofNullable(relations));
    }

    @NavigationProperty(name="terms")
    @JsonIgnore
    public TermCollectionRequest getTerms() {
        return new TermCollectionRequest(
                        contextPath.addSegment("terms"), Optional.ofNullable(terms));
    }

    public Set withChildren(List<Term> children) {
        Set _x = _copy();
        _x.changedFields = changedFields.add("children");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.set");
        _x.children = children;
        return _x;
    }

    public Set withParentGroup(Group parentGroup) {
        Set _x = _copy();
        _x.changedFields = changedFields.add("parentGroup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.set");
        _x.parentGroup = parentGroup;
        return _x;
    }

    public Set withRelations(List<Relation> relations) {
        Set _x = _copy();
        _x.changedFields = changedFields.add("relations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.set");
        _x.relations = relations;
        return _x;
    }

    public Set withTerms(List<Term> terms) {
        Set _x = _copy();
        _x.changedFields = changedFields.add("terms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.set");
        _x.terms = terms;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Set patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Set _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Set put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Set _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Set _copy() {
        Set _x = new Set();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.localizedNames = localizedNames;
        _x.properties = properties;
        _x.children = children;
        _x.parentGroup = parentGroup;
        _x.relations = relations;
        _x.terms = terms;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Set[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("localizedNames=");
        b.append(this.localizedNames);
        b.append(", ");
        b.append("properties=");
        b.append(this.properties);
        b.append(", ");
        b.append("children=");
        b.append(this.children);
        b.append(", ");
        b.append("parentGroup=");
        b.append(this.parentGroup);
        b.append(", ");
        b.append("relations=");
        b.append(this.relations);
        b.append(", ");
        b.append("terms=");
        b.append(this.terms);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
