package odata.msgraph.client.beta.termStore.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.termStore.entity.collection.request.SetCollectionRequest;
import odata.msgraph.client.beta.termStore.enums.TermGroupScope;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "parentSiteId", 
    "scope", 
    "sets"})
@JsonInclude(Include.NON_NULL)
public class Group extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termStore.group";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("parentSiteId")
    protected String parentSiteId;

    @JsonProperty("scope")
    protected TermGroupScope scope;

    @JsonProperty("sets")
    protected List<Set> sets;

    protected Group() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private String parentSiteId;
        private TermGroupScope scope;
        private List<Set> sets;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder parentSiteId(String parentSiteId) {
            this.parentSiteId = parentSiteId;
            this.changedFields = changedFields.add("parentSiteId");
            return this;
        }

        public Builder scope(TermGroupScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder sets(List<Set> sets) {
            this.sets = sets;
            this.changedFields = changedFields.add("sets");
            return this;
        }

        public Builder sets(Set... sets) {
            return sets(Arrays.asList(sets));
        }

        public Group build() {
            Group _x = new Group();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termStore.group";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.parentSiteId = parentSiteId;
            _x.scope = scope;
            _x.sets = sets;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Group withCreatedDateTime(OffsetDateTime createdDateTime) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.group");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Group withDescription(String description) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.group");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Group withDisplayName(String displayName) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.group");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="parentSiteId")
    @JsonIgnore
    public Optional<String> getParentSiteId() {
        return Optional.ofNullable(parentSiteId);
    }

    public Group withParentSiteId(String parentSiteId) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("parentSiteId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.group");
        _x.parentSiteId = parentSiteId;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<TermGroupScope> getScope() {
        return Optional.ofNullable(scope);
    }

    public Group withScope(TermGroupScope scope) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.group");
        _x.scope = scope;
        return _x;
    }

    public Group withUnmappedField(String name, Object value) {
        Group _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="sets")
    @JsonIgnore
    public SetCollectionRequest getSets() {
        return new SetCollectionRequest(
                        contextPath.addSegment("sets"), Optional.ofNullable(sets));
    }

    public Group withSets(List<Set> sets) {
        Group _x = _copy();
        _x.changedFields = changedFields.add("sets");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.group");
        _x.sets = sets;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Group patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Group _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Group put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Group _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Group _copy() {
        Group _x = new Group();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.parentSiteId = parentSiteId;
        _x.scope = scope;
        _x.sets = sets;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Group[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("parentSiteId=");
        b.append(this.parentSiteId);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("sets=");
        b.append(this.sets);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
