package odata.msgraph.client.beta.termStore.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isDefault", 
    "languageTag", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class LocalizedLabel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("languageTag")
    protected String languageTag;

    @JsonProperty("name")
    protected String name;

    protected LocalizedLabel() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.termStore.localizedLabel";
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public LocalizedLabel withIsDefault(Boolean isDefault) {
        LocalizedLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.localizedLabel");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="languageTag")
    @JsonIgnore
    public Optional<String> getLanguageTag() {
        return Optional.ofNullable(languageTag);
    }

    public LocalizedLabel withLanguageTag(String languageTag) {
        LocalizedLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.localizedLabel");
        _x.languageTag = languageTag;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public LocalizedLabel withName(String name) {
        LocalizedLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.termStore.localizedLabel");
        _x.name = name;
        return _x;
    }

    public LocalizedLabel withUnmappedField(String name, Object value) {
        LocalizedLabel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isDefault;
        private String languageTag;
        private String name;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder languageTag(String languageTag) {
            this.languageTag = languageTag;
            this.changedFields = changedFields.add("languageTag");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public LocalizedLabel build() {
            LocalizedLabel _x = new LocalizedLabel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.termStore.localizedLabel";
            _x.isDefault = isDefault;
            _x.languageTag = languageTag;
            _x.name = name;
            return _x;
        }
    }

    private LocalizedLabel _copy() {
        LocalizedLabel _x = new LocalizedLabel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.isDefault = isDefault;
        _x.languageTag = languageTag;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocalizedLabel[");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("languageTag=");
        b.append(this.languageTag);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
