package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum WorkloadActionStatus implements Enum {

    @JsonProperty("toAddress")
    TO_ADDRESS("toAddress", "0"),

    @JsonProperty("completed")
    COMPLETED("completed", "5"),

    @JsonProperty("error")
    ERROR("error", "10"),

    @JsonProperty("timeOut")
    TIME_OUT("timeOut", "15"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "20"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "25");

    private final String name;
    private final String value;

    private WorkloadActionStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
