package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagementTemplateDeploymentStatus implements Enum {

    @JsonProperty("unknown")
    UNKNOWN("unknown", "0"),

    @JsonProperty("inProgress")
    IN_PROGRESS("inProgress", "5"),

    @JsonProperty("completed")
    COMPLETED("completed", "10"),

    @JsonProperty("failed")
    FAILED("failed", "15"),

    @JsonProperty("ineligible")
    INELIGIBLE("ineligible", "20"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "45");

    private final String name;
    private final String value;

    private ManagementTemplateDeploymentStatus(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
