package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagementParameterValueType implements Enum {

    @JsonProperty("string")
    STRING("string", "0"),

    @JsonProperty("integer")
    INTEGER("integer", "1"),

    @JsonProperty("boolean")
    BOOLEAN("boolean", "2"),

    @JsonProperty("guid")
    GUID("guid", "3"),

    @JsonProperty("stringCollection")
    STRING_COLLECTION("stringCollection", "4"),

    @JsonProperty("integerCollection")
    INTEGER_COLLECTION("integerCollection", "5"),

    @JsonProperty("booleanCollection")
    BOOLEAN_COLLECTION("booleanCollection", "6"),

    @JsonProperty("guidCollection")
    GUID_COLLECTION("guidCollection", "7"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "8");

    private final String name;
    private final String value;

    private ManagementParameterValueType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
