package odata.msgraph.client.beta.managed.tenants.enums;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum ManagementCategory implements Enum {

    @JsonProperty("custom")
    CUSTOM("custom", "0"),

    @JsonProperty("devices")
    DEVICES("devices", "1"),

    @JsonProperty("identity")
    IDENTITY("identity", "2"),

    @JsonProperty("data")
    DATA("data", "3"),

    @JsonProperty("unknownFutureValue")
    @JsonEnumDefaultValue
    UNKNOWN_FUTURE_VALUE("unknownFutureValue", "4");

    private final String name;
    private final String value;

    private ManagementCategory(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
