package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.Tenant;

@JsonIgnoreType
public class TenantRequest extends EntityRequest<Tenant> {

    public TenantRequest(ContextPath contextPath, Optional<Object> value) {
        super(Tenant.class, contextPath, value, false);
    }

    @Action(name = "offboardTenant")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Tenant> offboardTenant() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Tenant>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.offboardTenant"), Tenant.class, _parameters);
    }

    @Action(name = "resetTenantOnboardingStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Tenant> resetTenantOnboardingStatus() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Tenant>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.resetTenantOnboardingStatus"), Tenant.class, _parameters);
    }

}
