package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplateStepVersion;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepDeploymentCollectionRequest;

@JsonIgnoreType
public class ManagementTemplateStepVersionRequest extends EntityRequest<ManagementTemplateStepVersion> {

    public ManagementTemplateStepVersionRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagementTemplateStepVersion.class, contextPath, value, false);
    }

    public ManagementTemplateStepRequest acceptedFor() {
        return new ManagementTemplateStepRequest(contextPath.addSegment("acceptedFor"), Optional.empty());
    }

    public ManagementTemplateStepDeploymentRequest deployments(String id) {
        return new ManagementTemplateStepDeploymentRequest(contextPath.addSegment("deployments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateStepDeploymentCollectionRequest deployments() {
        return new ManagementTemplateStepDeploymentCollectionRequest(
                        contextPath.addSegment("deployments"), Optional.empty());
    }

    public ManagementTemplateStepRequest templateStep() {
        return new ManagementTemplateStepRequest(contextPath.addSegment("templateStep"), Optional.empty());
    }

}
