package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplateStepDeployment;

@JsonIgnoreType
public class ManagementTemplateStepDeploymentRequest extends EntityRequest<ManagementTemplateStepDeployment> {

    public ManagementTemplateStepDeploymentRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagementTemplateStepDeployment.class, contextPath, value, false);
    }

    public ManagementTemplateStepVersionRequest templateStepVersion() {
        return new ManagementTemplateStepVersionRequest(contextPath.addSegment("templateStepVersion"), Optional.empty());
    }

    @Action(name = "changeDeploymentStatus")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ManagementTemplateStepDeployment> changeDeploymentStatus(String tenantId, String managementTemplateStepId, String status) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .put("managementTemplateStepId", "Edm.String", Checks.checkIsAscii(managementTemplateStepId))
            .put("status", "Edm.String", Checks.checkIsAscii(status))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ManagementTemplateStepDeployment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.changeDeploymentStatus"), ManagementTemplateStepDeployment.class, _parameters);
    }

}
