package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplate;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateStepCollectionRequest;

@JsonIgnoreType
public class ManagementTemplateRequest extends EntityRequest<ManagementTemplate> {

    public ManagementTemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagementTemplate.class, contextPath, value, false);
    }

    public ManagementTemplateCollectionRequest managementTemplateCollections(String id) {
        return new ManagementTemplateCollectionRequest(contextPath.addSegment("managementTemplateCollections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateCollectionCollectionRequest managementTemplateCollections() {
        return new ManagementTemplateCollectionCollectionRequest(
                        contextPath.addSegment("managementTemplateCollections"), Optional.empty());
    }

    public ManagementTemplateStepRequest managementTemplateSteps(String id) {
        return new ManagementTemplateStepRequest(contextPath.addSegment("managementTemplateSteps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateStepCollectionRequest managementTemplateSteps() {
        return new ManagementTemplateStepCollectionRequest(
                        contextPath.addSegment("managementTemplateSteps"), Optional.empty());
    }

}
