package odata.msgraph.client.beta.managed.tenants.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplateCollection;

@JsonIgnoreType
public class ManagementTemplateCollectionRequest extends EntityRequest<ManagementTemplateCollection> {

    public ManagementTemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(ManagementTemplateCollection.class, contextPath, value, false);
    }

    public ManagementTemplateRequest managementTemplates(String id) {
        return new ManagementTemplateRequest(contextPath.addSegment("managementTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionRequest managementTemplates() {
        return new odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionRequest(
                        contextPath.addSegment("managementTemplates"), Optional.empty());
    }

}
