package odata.msgraph.client.beta.managed.tenants.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplateStepVersion;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateStepDeploymentRequest;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateStepVersionRequest;

public class ManagementTemplateStepVersionCollectionRequest extends CollectionPageEntityRequest<ManagementTemplateStepVersion, ManagementTemplateStepVersionRequest>{

    protected ContextPath contextPath;

    public ManagementTemplateStepVersionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagementTemplateStepVersion.class, cp -> new ManagementTemplateStepVersionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagementTemplateStepDeploymentRequest deployments(String id) {
        return new ManagementTemplateStepDeploymentRequest(contextPath.addSegment("deployments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateStepDeploymentCollectionRequest deployments() {
        return new ManagementTemplateStepDeploymentCollectionRequest(contextPath.addSegment("deployments"), Optional.empty());
    }

}
