package odata.msgraph.client.beta.managed.tenants.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplate;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateRequest;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateStepRequest;

public class ManagementTemplateCollectionRequest extends CollectionPageEntityRequest<ManagementTemplate, ManagementTemplateRequest>{

    protected ContextPath contextPath;

    public ManagementTemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagementTemplate.class, cp -> new ManagementTemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateCollectionRequest managementTemplateCollections(String id) {
        return new odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateCollectionRequest(contextPath.addSegment("managementTemplateCollections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateCollectionCollectionRequest managementTemplateCollections() {
        return new ManagementTemplateCollectionCollectionRequest(contextPath.addSegment("managementTemplateCollections"), Optional.empty());
    }

    public ManagementTemplateStepRequest managementTemplateSteps(String id) {
        return new ManagementTemplateStepRequest(contextPath.addSegment("managementTemplateSteps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementTemplateStepCollectionRequest managementTemplateSteps() {
        return new ManagementTemplateStepCollectionRequest(contextPath.addSegment("managementTemplateSteps"), Optional.empty());
    }

}
