package odata.msgraph.client.beta.managed.tenants.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.managed.tenants.entity.ManagementTemplateCollection;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateCollectionRequest;
import odata.msgraph.client.beta.managed.tenants.entity.request.ManagementTemplateRequest;

public class ManagementTemplateCollectionCollectionRequest extends CollectionPageEntityRequest<ManagementTemplateCollection, ManagementTemplateCollectionRequest>{

    protected ContextPath contextPath;

    public ManagementTemplateCollectionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ManagementTemplateCollection.class, cp -> new ManagementTemplateCollectionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ManagementTemplateRequest managementTemplates(String id) {
        return new ManagementTemplateRequest(contextPath.addSegment("managementTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionRequest managementTemplates() {
        return new odata.msgraph.client.beta.managed.tenants.entity.collection.request.ManagementTemplateCollectionRequest(contextPath.addSegment("managementTemplates"), Optional.empty());
    }

}
