package odata.msgraph.client.beta.managed.tenants.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Entity;
import odata.msgraph.client.beta.managed.tenants.complex.TenantInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "createdByUserId", 
    "createdDateTime", 
    "deletedDateTime", 
    "description", 
    "displayName", 
    "lastActionByUserId", 
    "lastActionDateTime", 
    "tenants"})
@JsonInclude(Include.NON_NULL)
public class TenantTag extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.managedTenants.tenantTag";
    }

    @JsonProperty("createdByUserId")
    protected String createdByUserId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deletedDateTime")
    protected OffsetDateTime deletedDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastActionByUserId")
    protected String lastActionByUserId;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("tenants")
    protected List<TenantInfo> tenants;

    @JsonProperty("tenants@nextLink")
    protected String tenantsNextLink;

    protected TenantTag() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTenantTag() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String createdByUserId;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private String lastActionByUserId;
        private OffsetDateTime lastActionDateTime;
        private List<TenantInfo> tenants;
        private String tenantsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdByUserId(String createdByUserId) {
            this.createdByUserId = createdByUserId;
            this.changedFields = changedFields.add("createdByUserId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastActionByUserId(String lastActionByUserId) {
            this.lastActionByUserId = lastActionByUserId;
            this.changedFields = changedFields.add("lastActionByUserId");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder tenants(List<TenantInfo> tenants) {
            this.tenants = tenants;
            this.changedFields = changedFields.add("tenants");
            return this;
        }

        public Builder tenants(TenantInfo... tenants) {
            return tenants(Arrays.asList(tenants));
        }

        public Builder tenantsNextLink(String tenantsNextLink) {
            this.tenantsNextLink = tenantsNextLink;
            this.changedFields = changedFields.add("tenants");
            return this;
        }

        public TenantTag build() {
            TenantTag _x = new TenantTag();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.managedTenants.tenantTag";
            _x.id = id;
            _x.createdByUserId = createdByUserId;
            _x.createdDateTime = createdDateTime;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastActionByUserId = lastActionByUserId;
            _x.lastActionDateTime = lastActionDateTime;
            _x.tenants = tenants;
            _x.tenantsNextLink = tenantsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdByUserId")
    @JsonIgnore
    public Optional<String> getCreatedByUserId() {
        return Optional.ofNullable(createdByUserId);
    }

    public TenantTag withCreatedByUserId(String createdByUserId) {
        TenantTag _x = _copy();
        _x.changedFields = changedFields.add("createdByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantTag");
        _x.createdByUserId = createdByUserId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public TenantTag withCreatedDateTime(OffsetDateTime createdDateTime) {
        TenantTag _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantTag");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="deletedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeletedDateTime() {
        return Optional.ofNullable(deletedDateTime);
    }

    public TenantTag withDeletedDateTime(OffsetDateTime deletedDateTime) {
        TenantTag _x = _copy();
        _x.changedFields = changedFields.add("deletedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantTag");
        _x.deletedDateTime = deletedDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public TenantTag withDescription(String description) {
        TenantTag _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantTag");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public TenantTag withDisplayName(String displayName) {
        TenantTag _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantTag");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastActionByUserId")
    @JsonIgnore
    public Optional<String> getLastActionByUserId() {
        return Optional.ofNullable(lastActionByUserId);
    }

    public TenantTag withLastActionByUserId(String lastActionByUserId) {
        TenantTag _x = _copy();
        _x.changedFields = changedFields.add("lastActionByUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantTag");
        _x.lastActionByUserId = lastActionByUserId;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public TenantTag withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        TenantTag _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantTag");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="tenants")
    @JsonIgnore
    public CollectionPage<TenantInfo> getTenants() {
        return new CollectionPage<TenantInfo>(contextPath, TenantInfo.class, this.tenants, Optional.ofNullable(tenantsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public TenantTag withTenants(List<TenantInfo> tenants) {
        TenantTag _x = _copy();
        _x.changedFields = changedFields.add("tenants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.managedTenants.tenantTag");
        _x.tenants = tenants;
        return _x;
    }

    @Property(name="tenants")
    @JsonIgnore
    public CollectionPage<TenantInfo> getTenants(HttpRequestOptions options) {
        return new CollectionPage<TenantInfo>(contextPath, TenantInfo.class, this.tenants, Optional.ofNullable(tenantsNextLink), Collections.emptyList(), options);
    }

    public TenantTag withUnmappedField(String name, Object value) {
        TenantTag _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantTag patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        TenantTag _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public TenantTag put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        TenantTag _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private TenantTag _copy() {
        TenantTag _x = new TenantTag();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdByUserId = createdByUserId;
        _x.createdDateTime = createdDateTime;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastActionByUserId = lastActionByUserId;
        _x.lastActionDateTime = lastActionDateTime;
        _x.tenants = tenants;
        return _x;
    }

    @Action(name = "assignTag")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TenantTag> assignTag(List<String> tenantIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantIds", "Collection(Edm.String)", Checks.checkIsAscii(tenantIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TenantTag>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.assignTag"), TenantTag.class, _parameters);
    }

    @Action(name = "unassignTag")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<TenantTag> unassignTag(List<String> tenantIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantIds", "Collection(Edm.String)", Checks.checkIsAscii(tenantIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<TenantTag>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedTenants.unassignTag"), TenantTag.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TenantTag[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdByUserId=");
        b.append(this.createdByUserId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastActionByUserId=");
        b.append(this.lastActionByUserId);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("tenants=");
        b.append(this.tenants);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
